/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class TGBaseStructure
extends Structure<NoFeatureConfig> {
    private final int SUNKEN_IN;
    private final double SIZE;
    private final String NAME;
    private int averageHeight;
    private final int MAX_TERRAIN_DIFFERENCE_BASE = 2;
    private final int MAX_TERRAIN_DIFFERENCE_LG = 4;

    public TGBaseStructure(Codec<NoFeatureConfig> codec, String name, double size, int sunkenIn) {
        super(codec);
        this.SUNKEN_IN = sunkenIn;
        this.SIZE = size;
        this.NAME = name;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16);
        if (!this.isTerrainFlat(chunkGenerator, centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p())) {
            return false;
        }
        if (!this.isWater(chunkGenerator, centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p())) {
            return false;
        }
        return !(this.SIZE > 2.0) || this.checkForOtherStructures(chunkGenerator, seed, chunkRandom, centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
    }

    protected boolean isWater(ChunkGenerator generator, int chunkX, int chunkZ) {
        int offset = (int)this.SIZE * 15;
        Set biomesInArea = generator.func_202090_b().func_225530_a_(chunkX, 0, chunkZ, offset);
        for (Biome biome : biomesInArea) {
            if (biome.func_201856_r() != Biome.Category.OCEAN && biome.func_201856_r() != Biome.Category.RIVER) continue;
            return false;
        }
        return true;
    }

    protected boolean isTerrainFlat(ChunkGenerator generator, int chunkX, int chunkZ) {
        int offset = (int)this.SIZE * 8;
        int i1 = generator.func_222532_b(chunkX, chunkZ, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222532_b(chunkX, chunkZ + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222532_b(chunkX + offset, chunkZ, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222532_b(chunkX + offset, chunkZ + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int m1 = generator.func_222532_b(chunkX - offset, chunkZ + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int n1 = generator.func_222532_b(chunkX + offset, chunkZ - offset, Heightmap.Type.WORLD_SURFACE_WG);
        int o1 = generator.func_222532_b(chunkX, chunkZ - offset, Heightmap.Type.WORLD_SURFACE_WG);
        int p1 = generator.func_222532_b(chunkX - offset, chunkZ, Heightmap.Type.WORLD_SURFACE_WG);
        int q1 = generator.func_222532_b(chunkX - offset, chunkZ - offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minCorners = Math.min(Math.min(n1, m1), Math.min(q1, l1));
        int minSides = Math.min(Math.min(j1, p1), Math.min(o1, k1));
        int minHeight = Math.min(Math.min(minCorners, minSides), i1);
        int maxCorners = Math.max(Math.max(n1, m1), Math.max(q1, l1));
        int maxSides = Math.max(Math.max(j1, p1), Math.max(o1, k1));
        int maxHeight = Math.max(Math.max(maxCorners, maxSides), i1);
        this.averageHeight = Math.abs((maxHeight + minHeight) / 2) - 1;
        if (this.SIZE > 2.0) {
            return Math.abs(maxHeight - minHeight) <= 4;
        }
        return Math.abs(maxHeight - minHeight) <= 2;
    }

    public boolean checkForOtherStructures(ChunkGenerator generator, long seed, SharedSeedRandom random, int chunkX, int chunkZ) {
        StructureSeparationSettings structureConfig = generator.func_235957_b_().func_236197_a_(Structure.field_236381_q_);
        if (structureConfig == null) {
            return false;
        }
        int blocksAwayToCheck = 15;
        for (int k = chunkX - blocksAwayToCheck; k <= chunkX + blocksAwayToCheck; ++k) {
            for (int l = chunkZ - blocksAwayToCheck; l <= chunkZ + blocksAwayToCheck; ++l) {
                ChunkPos chunkPos = Structure.field_236381_q_.func_236392_a_(structureConfig, seed, random, k, l);
                if (k != chunkPos.field_77276_a || l != chunkPos.field_77275_b) continue;
                return false;
            }
        }
        return true;
    }

    private int getSunkenIn() {
        return this.SUNKEN_IN;
    }

    private double getSize() {
        return this.SIZE;
    }

    private String getStructureName() {
        return this.NAME;
    }

    private int getAverageHeight() {
        return this.averageHeight;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private final int SUNKEN_IN;
        private final double SIZE;
        private final String NAME;
        private int averageHeight;

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox blockBox, int referenceIn, long seedIn, String name, double size, int sunkenIn, int averageHeight) {
            super(structureIn, chunkX, chunkZ, blockBox, referenceIn, seedIn);
            this.SIZE = size;
            this.SUNKEN_IN = sunkenIn;
            this.NAME = name;
            this.averageHeight = averageHeight;
        }

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox blockBox, int referenceIn, long seed) {
            this(structureIn, chunkX, chunkZ, blockBox, referenceIn, seed, ((TGBaseStructure)structureIn).getStructureName(), ((TGBaseStructure)structureIn).getSize(), ((TGBaseStructure)structureIn).getSunkenIn(), ((TGBaseStructure)structureIn).getAverageHeight());
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos.Mutable centerPos = new BlockPos.Mutable(x, this.averageHeight, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("graveyard", this.NAME + "/start_pool")), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.field_75075_a.forEach(piece -> piece.func_74874_b().func_78886_a(0, this.SUNKEN_IN, 0));
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = centerPos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = centerPos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }
    }
}

